<?php
/**
 * This file is used to generate the "Export" page in the admin.
 */

if ( ! current_user_can( get_option( $this->shared->get( 'slug' ) . '_export_menu_capability' ) ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'daln' ) );
}

?>

<!-- output -->

<div class="wrap">

	<h2><?php esc_html_e( 'Live News - Export', 'daln' ); ?></h2>

	<div id="daext-menu-wrapper">

		<p>
		<?php
		esc_html_e(
			'Click the Export button to generate an XML file that includes all the plugin data.',
			'daln'
		);
		?>
				</p>

		<!-- the data sent through this form are handled by the export_xml_controller() method called with the WordPress init action -->
		<form method="POST" action="admin.php?page=daln-export">

			<div>
				<input name="daln_export" class="button button-primary" type="submit"
						value="
						<?php
						esc_attr_e(
							'Export',
							'daln'
						);
						?>
							" 
							<?php
							if ( ! $this->shared->plugin_has_data() ) {
												echo 'disabled="disabled"';
							}
							?>
				>
			</div>

		</form>

	</div>

</div>